local SignScreen 	= require "screens/signscreen"

local function gettext(inst, viewer)
    local text = inst.components.signable:GetText()
    if string.len(text) < 1 then
    	text = "Nothing Written"
    end
    return text
end

--[[
local function onbuilt(inst, data)
    inst.components.signable:OnSign(data.builder)
end
]]

local Signable = Class(function(self, inst)
	self.inst = inst
	self.text = ""
	self.signed = false
	
	self.inst.components.inspectable.description = gettext
	
    --self.inst:ListenForEvent("onbuilt", onbuilt)
end)

function Signable:CollectSceneActions(doer, actions, right)
	if not self.signed and not right then
		 table.insert(actions, ACTIONS.SIGNEDIT)
	end
end

function Signable:OnSave()
    local data = {}

    data.text = self.text

    return data
end

function Signable:OnLoad(data)
    self.text = data.text
    if string.len(self.text) > 0 then
    	self.signed = true
    end
end

function Signable:GetText()
    return self.text
end

function Signable:SetText(text)
    self.text = text
end

function Signable:OnSign(doer)
	if self.signed and self.inst and self.inst.components and self.inst.components.talker then
		self.inst.components.talker:Say(self.text)
	elseif not self.signed then
		TheFrontEnd:PushScreen(SignScreen(self.inst))
	end
end

return Signable